#include "Tokenizer.h"
#include <algorithm>
#include <string>

Tokenizer::Tokenizer() : buffer(""), token(""), delimiter(DEFAULT_DELIMITER)
{
    currPos = buffer.begin();
}

Tokenizer::Tokenizer(const string& str, const string& delimiter) : buffer(str), token(""), delimiter(delimiter)
{
    currPos = buffer.begin();
}

void Tokenizer::set(const string& str, const string& delimiter)
{
    this->buffer = str;
    this->delimiter = delimiter;
    this->currPos = buffer.begin();
}

void Tokenizer::setString(const string& str)
{
    this->buffer = str;
    this->currPos = buffer.begin();
}

void Tokenizer::setDelimiter(const string& delimiter)
{
    this->delimiter = delimiter;
    this->currPos = buffer.begin();
}

string Tokenizer::next()
{
    if(buffer.size() <= 0) return "";           // skip if buffer is empty

    token.clear();                              // reset token string

    this->skipDelimiter();                      // skip leading delimiters

    // append each char to token string until it meets delimiter
    while(currPos != buffer.end() && !isDelimiter(*currPos))
    {
        token += *currPos;
        ++currPos;
    }
    return token;
}

void Tokenizer::skipDelimiter()
{
    while(currPos != buffer.end() && isDelimiter(*currPos))
        ++currPos;
}

bool Tokenizer::isDelimiter(char c)
{
    return (delimiter.find(c) != string::npos);
}

vector<string> Tokenizer::split()
{
    vector<string> tokens;
    string token;
    while((token = this->next()) != "")
    {
        transform(token.begin(), token.end(), token.begin(), ::tolower);
        tokens.push_back(token);
    }

    return tokens;
}
